# Step 1: Simulation Conditions

# Load packages
library(magrittr)
library(dplyr)

# Conditions + levels
samplesize <- c(300)
resp_options <- c(2, 3, 4, 5)
resp_pattern <- c("balanced", "sparse1", "sparse2")
num_ind <- c(3, 6)
prop_sparse <- c(0, .33, .66, 1)
loading_mag <- c(.4, .6, .8)

# Condition grid
sim_conditions <- expand.grid(samplesize, resp_options, resp_pattern, 
                              num_ind, prop_sparse, loading_mag)

colnames(sim_conditions) <- c("samplesize", "resp_options", "resp_pattern",
                              "num_ind", "prop_sparse", "loading_mag")

# Filter out impossible combinations 
sim_conditions <- sim_conditions %>% 
  filter(!(resp_pattern == "balanced" & prop_sparse %in% c(.33, .66, 1)) & !(resp_pattern == "sparse1" & prop_sparse == 0) & !(resp_pattern == "sparse2" & prop_sparse == 0)) %>%
  filter(!(resp_options == 2 & resp_pattern == "sparse2"))

# Save
saveRDS(sim_conditions, file = "data/simconditions.RDS")
