# Simulation Execution File

# Check if all required packages are installed
required_packages <- c("magrittr", "dplyr", "foreach", "parallel", "doRNG",
                       "lavaan", "tidyr", "ggplot2", "effectsize", "jtools")

missing_packages <- required_packages[!(required_packages %in% installed.packages()[,"Package"])]
if(length(missing_packages) > 0) {install.packages(missing_packages)}

# Set up folders if they don't exist yet
if(!dir.exists("data")) {dir.create("data")}
if(!dir.exists("results")) {dir.create("results")}
if(!dir.exists("figures")) {dir.create("figures")}

# Set up number of cores/cpu for data generation and simulation run files
# Change this number to a higher number (if possible) to speed up the run time
n.cores <- 2

# Execute simulation files
source("simulation_condition.R")
source("simulation_data.R")
source("simulation_run_simple.R")
source("simulation_run_default.R")
source("simulation_results_simple.R")
source("simulation_results_default.R")